@extends('admin.template')
@section('styles')
<style>
    body{overflow-x:hidden;}
</style>
@endsection
@section('content')
@section('content')
    <div class="row" id="basic-table">
        <div class="col-12">
            <div class="card">
                <div class="card-header mt-2">
                    <h5 class="card-title">Registrar Encomienda</h5>
                </div>
                <div class="card-body">
                    <form id="form_save_reference" class="form form-vertical">
                        @csrf
                        <div class="row">
                            <div class="col-12 col-md-3 mb-3">
                                <input type="hidden" name="contrasena">
                                <label class="form-label" for="idtipo_comprobante">Tipo Comprobante</label>
                                <select class="form-control" id="idtipo_comprobante"
                                    name="idtipo_comprobante" disabled>
                                    @foreach ($type_documents_p as $type_document)
                                        <option value="{{ $type_document->id }}">{{ $type_document->descripcion }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-12 col-md-2 mb-3">
                                <label class="form-label" for="serie">Serie</label>
                                <input type="text" id="serie" class="form-control text-uppercase"
                                    name="serie" />
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="col-12 col-md-3 mb-3">
                                <label class="form-label" for="correlativo">N&uacute;mero</label>
                                <input type="text" id="correlativo" class="form-control text-uppercase"
                                    name="correlativo" />
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="col-md-1"></div>

                            <div class="col-12 col-md-3 mb-3">
                                <label class="form-label" for="fecha_traslado">Fecha de salida</label>
                                <input type="date" id="fecha_traslado" class="form-control"
                                    name="fecha_traslado" value="{{ date('Y-m-d') }}">
                            </div>

                            <div class="col-12 col-md-4 mb-3">
                                <label class="form-label" for="idorigen">Origen</label>
                                {{-- <small class="text-primary fw-bold btn-create-origin" style="cursor: pointer">[+
                                    Nuevo]</small> --}}
                                <select class="select2-size-sm form-control" id="idorigen" name="idorigen">
                                    @foreach ($origins as $origin)
                                        <option value="{{ $origin->id }}">
                                            {{ $origin->distrito }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-12 col-md-4 mb-3">
                                <label class="form-label" for="iddestino">Destino</label>
                                {{-- <small class="text-primary fw-bold btn-create-origin" style="cursor: pointer">[+
                                    Nuevo]</small> --}}
                                <select class="select2-size-sm form-control" id="iddestino" name="iddestino">
                                    @foreach ($destinations as $destination)
                                        <option value="{{ $destination->id }}">
                                            {{ $destination->distrito }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-1"></div>

                            <div class="col-12 col-md-3 mb-3">
                                    <label class="form-label" for="modo_pago">Pago:</label>
                                    <select class="form-control" id="modo_pago" name="modo_pago">
                                        @foreach ($modo_pagos as $modo_pago)
                                            <option value="{{ $modo_pago->id }}">{{ $modo_pago->descripcion }}</option>
                                        @endforeach
                                    </select>
                            </div>

                            <div class="col-12 col-md-4 mb-3">
                                <label class="form-label" for="idremitente">Remitente</label>
                                    <small class="text-primary fw-bold btn-create-sender" style="cursor: pointer">[+
                                        Nuevo]</small>
                                    <select class="select2-size-sm form-control" id="idremitente" name="idremitente">
                                        @foreach ($senders as $sender)
                                            <option value="{{ $sender->id }}">
                                                {{ $sender->dni_ruc . ' - ' . $sender->nombres }}</option>
                                        @endforeach
                                </select>
                            </div>

                            <div class="col-12 col-md-4 mb-3">
                                <label class="form-label" for="iddestinatario">Destinatario</label>
                                    <small class="text-primary fw-bold btn-create-client" style="cursor: pointer">[+
                                        Nuevo]</small>
                                    <select class="select2-size-sm form-control" id="iddestinatario" name="iddestinatario">
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->id }}">
                                                {{ $client->dni_ruc . ' - ' . $client->nombres }}</option>
                                        @endforeach
                                </select>
                            </div>

                            <div class="col-md-1"></div>

                            <div class="col-12 col-md-3 mb-3">
                                <label class="form-label" for="idconductor">Conductor</label>
                                    <small class="text-primary fw-bold btn-create-driver" style="cursor: pointer">[+
                                        Nuevo]</small>
                                    <select class="select2-size-sm form-control" id="idconductor" name="idconductor">
                                        @foreach ($drivers as $driver)
                                            <option value="{{ $driver->id }}">
                                                {{ $driver->nombres }}</option>
                                        @endforeach
                                </select>
                            </div>

                            
                        </div>

                        <div class="row invoice-add mt-3">
                            <div class="col-md-12">
                                <div class="table-responsive-sm">
                                    <table class="table table-sm">
                                        <thead>
                                            <tr>
                                                <th width="8%" class="text-center">#</th>
                                                <th class="">Descripción</th>
                                                <th class="text-center">Und.</th>
                                                <th class="text-center" width="13%">&nbsp;&nbsp;&nbsp;Cantidad&nbsp;&nbsp;&nbsp;</th>
                                                <th class="text-center" width="14%">Precio Unitario</th>
                                                <th class="text-center" width="10%">Importe</th>
                                                <th class="text-right" width="5%"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody_reference_guides"></tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-6 d-flex align-items-end mt-2">
                                <div class="form-group">
                                    <button type="button"
                                        class="btn btn-primary btn-add-product waves-effect waves-float waves-light"
                                        data-repeater-create="">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-plus mr-25">
                                            <line x1="12" y1="5" x2="12" y2="19"></line>
                                            <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                        <span class="align-middle">Agregar Producto</span>
                                    </button>
                                </div>
                            </div>

                            <div class="col-md-12 d-flex justify-content-end -0 p-sm-4">
                                <div id="wrapper_totals" class="invoice-calculations"></div>
                            </div>

                            <div class="col-12">
                                <div class="col-12 text-end">
                                    <a href="{{ route('admin.reference_guides') }}" class="btn btn-secondary">Cancelar</a>
                                    <button type="button" class="btn btn-primary btn-save">
                                        <span class="text-save">Guardar </span>
                                        <span class="spinner-border spinner-border-sm text-saving d-none" role="status"
                                            aria-hidden="true"></span>
                                        <span class="ml-25 align-middle text-saving d-none">Guardando...</span>
                                    </button>
                                </div>
                            </div>


                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    @include('admin.clients.modal-register')
    @include('admin.senders.modal-register')
    @include('admin.drivers.modal-register')
    @include('admin.reference_guides.create.modals-create')
    @include('admin.products.modal-add-cart')
    @include('admin.products.modal-register')
@endsection
@section('scripts')
@include('admin.clients.js-register')
@include('admin.senders.js-register')
@include('admin.drivers.js-register')
@include('admin.reference_guides.create.js-create')
@include('admin.products.js-register')
@endsection
