@extends('admin.template')
@section('content')
    <div class="row" id="basic-table">
        <div class="col-12">
            <div class="card">

                <div class="card-header d-flex justify-content-between">
                    <div class="card-title mb-0">
                        <h5 class="card-title mb-0">Gesti&oacute;n de Encomiendas</h5>
                    </div>
                    <a href="{{ route('admin.create_reference_guide') }}"
                        class="dt-button create-new btn btn-primary waves-effect waves-light">
                        <span><i class="ti ti-plus me-sm-1"></i><span class="d-none d-sm-inline-block">Nuevo</span></span>
                    </a>
                </div>
                <div class="p-3">
                    <div class="table-responsive">
                        <table id="table" class="table table-sm">
                            <thead class="table-light">
                                <tr>
                                    <th width="11%">Documento</th>
                                    <th width="10%">Fecha Traslado</th>
                                    <th width="10%">RUC/DNI</th>
                                    <th class="text-left">Destinatario</th>
                                    <th width="10%">Origen</th>
                                    <th width="10%">Destino</th>
                                    <th width="10%">Pago</th>
                                    <th width="10%">Estado Env&iacute;o</th>
                                    <th width="10%">Acciones</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        @include('admin.reference_guides.modals')
        @include('admin.drivers.modal-register')
    </div>
@endsection
@section('scripts')
    @include('admin.reference_guides.js-datatable')
    @include('admin.reference_guides.js-store')
    @include('admin.drivers.js-register')
    @if (session('alert'))
        <script>
            toast_msg("{{ session('alert') }}", 'warning');
        </script>
    @endif
@endsection
