<?php

use App\Http\Controllers\AlertController;
use App\Http\Controllers\ArchingCashController;
use App\Http\Controllers\BillController;
use App\Http\Controllers\BillingController;
use App\Http\Controllers\BillReportController;
use App\Http\Controllers\BusinessController;
use App\Http\Controllers\BuyController;
use App\Http\Controllers\CashController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ContactReportController;
use App\Http\Controllers\CreditNoteController;
use App\Http\Controllers\DestinationController;
use App\Http\Controllers\DriverController;
use App\Http\Controllers\ExtraController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\InventoryReportController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\OriginController;
use App\Http\Controllers\PosController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\ProviderController;
use App\Http\Controllers\PurchaseReportController;
use App\Http\Controllers\QuoteController;
use App\Http\Controllers\ReferenceGuideController;
use App\Http\Controllers\SaleNoteController;
use App\Http\Controllers\SaleReportController;
use App\Http\Controllers\SenderController;
use App\Http\Controllers\SerieController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/login'                          , [LoginController::class, 'index'])->name('login')->middleware('guest');
Route::post('/login-user'               , [LoginController::class, 'login'])->name('login.login');
Route::get('/logout'                    , [LoginController::class, 'logout'])->name('login.logout');

# Extra
Route::get('/prices'                    , [ExtraController::class, 'prices'])->name('admin.prices')->middleware('can:admin.prices'); 
Route::get('/faq'                       , [ExtraController::class, 'faq'])->name('admin.faq')->middleware('can:admin.faq'); 
Route::post('/send-voucher'             , [ExtraController::class, 'send_voucher'])->name('admin.send_voucher'); 

// Business
Route::get('/business'                  , [BusinessController::class, 'index'])->middleware('can:admin.business')->name('admin.business');
Route::post('/load-ubigeo'              , [BusinessController::class, 'load_ubigeo'])->name('admin.load_ubigeo');
Route::post('/load-provinces'           , [BusinessController::class, 'load_provinces'])->name('admin.load_provinces');
Route::post('/load-districts'           , [BusinessController::class, 'load_districts'])->name('admin.load_districts');
Route::post('/save-info-business'       , [BusinessController::class, 'save_info_business'])->name('admin.save_info_business');
Route::post('/save-info-user'           , [BusinessController::class, 'save_info_user'])->name('admin.save_info_user');
Route::post('/gen-json'                 , [BusinessController::class, 'gen_json'])->name('admin.gen_json');
## Home 
Route::get('/home'                      , [HomeController::class, 'index'])->name('admin.home')->middleware('auth'); 
Route::post('/load-alerts'              , [HomeController::class, 'alerts'])->name('admin.load_alerts');
Route::post('/dash-bills'               , [HomeController::class, 'dash_bills'])->name('admin.dash_bills');
Route::post('/dash-profits'             , [HomeController::class, 'dash_profits'])->name('admin.dash_profits');
Route::post('/dash-clients'             , [HomeController::class, 'dash_clients'])->name('admin.dash_clients');
Route::post('/dash-incomes'             , [HomeController::class, 'dash_incomes'])->name('admin.dash_incomes');
## Alerts 
Route::get('/alerts-stock'              , [AlertController::class, 'stock'])->name('admin.alerts_stock')->middleware('auth');
Route::post('/tbody-stocks'             , [AlertController::class, 'tbody_stocks'])->name('admin.load_tbody_stocks');
Route::get('/alerts-expiration'         , [AlertController::class, 'expiration'])->name('admin.alerts_expiration')->middleware('auth');
Route::post('/tbody-expirations'        , [AlertController::class, 'tbody_expirations'])->name('admin.load_tbody_expirations');
Route::get('/alerts-sale'               , [AlertController::class, 'sale'])->name('admin.alerts_sale')->middleware('auth');
Route::post('/tbody-sales'              , [AlertController::class, 'tbody_sales'])->name('admin.load_tbody_sales');
## Serie
Route::get('/series'                    , [SerieController::class, 'index'])->name('admin.series')->middleware('auth');
Route::get('/get-series'                , [SerieController::class, 'get'])->name('admin.get_series');
Route::post('/save-serie'               , [SerieController::class, 'save'])->name('admin.save_serie');
Route::post('/detail-serie'             , [SerieController::class, 'detail'])->name('admin.detail_serie');
Route::post('/store-serie'              , [SerieController::class, 'store'])->name('admin.store_serie');
Route::post('/delete-serie'             , [SerieController::class, 'delete'])->name('admin.delete_serie');
## Origen
Route::get('/origins'                   , [OriginController::class, 'index'])->name('admin.origins')->middleware('auth');
Route::get('/get-origins'               , [OriginController::class, 'get'])->name('admin.get_origins');
Route::post('/save-origin'              , [OriginController::class, 'save'])->name('admin.save_origin');
Route::post('/detail-origin'            , [OriginController::class, 'detail'])->name('admin.detail_origin');
Route::post('/store-origin'             , [OriginController::class, 'store'])->name('admin.store_origin');
Route::post('/delete-origin'            , [OriginController::class, 'delete'])->name('admin.delete_origin');
## Serie
Route::get('/destinations'              , [DestinationController::class, 'index'])->name('admin.destinations')->middleware('auth');
Route::get('/get-destinations'          , [DestinationController::class, 'get'])->name('admin.get_destinations');
Route::post('/save-destination'         , [DestinationController::class, 'save'])->name('admin.save_destination');
Route::post('/detail-destination'       , [DestinationController::class, 'detail'])->name('admin.detail_destination');
Route::post('/store-destination'        , [DestinationController::class, 'store'])->name('admin.store_destination');
Route::post('/delete-destination'       , [DestinationController::class, 'delete'])->name('admin.delete_destination');
## Cash
Route::get('/list-cashes'               , [CashController::class, 'index'])->name('admin.list_cashes')->middleware('auth');
Route::get('/get-cashes'                , [CashController::class, 'get'])->name('admin.get_cashes');
Route::post('/save-cash'                , [CashController::class, 'save'])->name('admin.save_cash');
Route::post('/detail-cash'              , [CashController::class, 'detail'])->name('admin.detail_cash');
Route::post('/store-cash'               , [CashController::class, 'store'])->name('admin.store_cash');
Route::post('/delete-cash'              , [CashController::class, 'delete'])->name('admin.delete_cash');
## Client
Route::get('/clients'                   , [ClientController::class, 'index'])->name('admin.clients')->middleware('auth');
Route::get('/get-clients'               , [ClientController::class, 'get'])->name('admin.get_clients');
Route::post('/load-ubigeo-client'       , [ClientController::class, 'load_ubigeo'])->name('admin.load_ubigeo_client');
Route::post('/search-dni-ruc'           , [ClientController::class, 'search'])->name('admin.search_dni_ruc');
Route::post('/save-client'              , [ClientController::class, 'save'])->name('admin.save_client');
Route::post('/detail-client'            , [ClientController::class, 'detail'])->name('admin.detail_client');
Route::post('/store-client'             , [ClientController::class, 'store'])->name('admin.store_client');
Route::post('/delete-client'            , [ClientController::class, 'delete'])->name('admin.delete_client');
## Sender
Route::get('/senders'                   , [SenderController::class, 'index'])->name('admin.senders')->middleware('auth');
Route::get('/get-senders'               , [SenderController::class, 'get'])->name('admin.get_senders');
Route::post('/load-ubigeo-sender'       , [SenderController::class, 'load_ubigeo'])->name('admin.load_ubigeo_sender');
Route::post('/save-sender'              , [SenderController::class, 'save'])->name('admin.save_sender');
Route::post('/detail-sender'            , [SenderController::class, 'detail'])->name('admin.detail_sender');
Route::post('/store-sender'             , [SenderController::class, 'store'])->name('admin.store_sender');
Route::post('/delete-sender'            , [SenderController::class, 'delete'])->name('admin.delete_sender');
## Drivers
Route::get('/drivers'                   , [DriverController::class, 'index'])->name('admin.drivers')->middleware('auth');
Route::get('/get-drivers'               , [DriverController::class, 'get'])->name('admin.get_drivers');
Route::post('/load-ubigeo-driver'       , [DriverController::class, 'load_ubigeo'])->name('admin.load_ubigeo_driver');
Route::post('/save-driver'              , [DriverController::class, 'save'])->name('admin.save_driver');
Route::post('/detail-driver'            , [DriverController::class, 'detail'])->name('admin.detail_driver');
Route::post('/store-driver'             , [DriverController::class, 'store'])->name('admin.store_driver');
Route::post('/delete-driver'            , [DriverController::class, 'delete'])->name('admin.delete_driver');
## Provider
Route::get('/providers'                 , [ProviderController::class, 'index'])->name('admin.providers')->middleware('auth');
Route::get('/get-providers'             , [ProviderController::class, 'get'])->name('admin.get_providers');
Route::post('/save-provider'            , [ProviderController::class, 'save'])->name('admin.save_provider');
Route::post('/detail-provider'          , [ProviderController::class, 'detail'])->name('admin.detail_provider');
Route::post('/store-provider'           , [ProviderController::class, 'store'])->name('admin.store_provider');
Route::post('/delete-provider'          , [ProviderController::class, 'delete'])->name('admin.delete_provider');
## Roles
Route::get('/roles'                     , [RoleController::class, 'index'])->name('admin.roles')->middleware('can:admin.roles');
Route::get('/get-roles'                 , [RoleController::class, 'get'])->name('admin.get_roles');
Route::post('/save-role'                , [RoleController::class, 'save'])->name('admin.save_role');
Route::post('/detail-role'              , [RoleController::class, 'detail'])->name('admin.detail_role');
Route::post('/store-role'               , [RoleController::class, 'store'])->name('admin.store_role');
Route::post('/delete-role'              , [RoleController::class, 'delete'])->name('admin.delete_role');
## Product
Route::get('/products'                  , [ProductController::class, 'index'])->name('admin.products')->middleware('can:admin.products');
Route::get('/get-products'              , [ProductController::class, 'get'])->name('admin.get_products');
Route::post('/save-product'             , [ProductController::class, 'save'])->name('admin.save_product');
Route::post('/detail-product'           , [ProductController::class, 'detail'])->name('admin.detail_product');
Route::post('/store-product'            , [ProductController::class, 'store'])->name('admin.store_product');
Route::post('/delete-product'           , [ProductController::class, 'delete'])->name('admin.delete_product');
Route::post('/upload-excel'             , [ProductController::class, 'upload'])->name('admin.upload_excel');
Route::get('/download-excel'            , [ProductController::class, 'download'])->name('admin.download_excel');
Route::post('/view-stocks'              , [ProductController::class, 'view_stocks'])->name('admin.view_stocks');
## Bill
Route::get('/bills'                     , [BillController::class, 'index'])->name('admin.bills')->middleware('can:admin.bills');
Route::get('/get-bills'                 , [BillController::class, 'get'])->name('admin.get_bills');
Route::post('/save-bill'                , [BillController::class, 'save'])->name('admin.save_bill');
Route::post('/delete-bill'              , [BillController::class, 'delete'])->name('admin.delete_bill');
## Buy
Route::get('/buys'                      , [BuyController::class, 'index'])->name('admin.buys')->middleware('can:admin.buys');
Route::get('/get-buys'                  , [BuyController::class, 'get'])->name('admin.get_buys');
Route::get('/create-buy'                , [BuyController::class, 'create'])->name('admin.create_buy')->middleware('can:admin.create_buy');
Route::post('/load-serie-buy'           , [BuyController::class, 'load_serie'])->name('admin.load_serie_buy');
Route::post('/get-serie-buy'            , [BuyController::class, 'get_serie'])->name('admin.get_serie_buy');
Route::post('/get-price-product-buy'    , [BuyController::class, 'get_price_product'])->name('admin.get_price_product_buy');
Route::post('/add-product-buy'          , [BuyController::class, 'add_product'])->name('admin.add_product_buy');
Route::post('/load-cart-buys'           , [BuyController::class, 'load_cart'])->name('admin.load_cart_buys');
Route::post('/delete-product-buy'       , [BuyController::class, 'delete_product'])->name('admin.delete_product_buy');
Route::post('/store-product-buy'        , [BuyController::class, 'store_product'])->name('admin.store_product_buy');
Route::post('/get-providers-update'     , [BuyController::class, 'get_providers_update'])->name('admin.get_providers_update');
Route::post('/save-buy'                 , [BuyController::class, 'save'])->name('admin.save_buy');
Route::post('/get-products-update'      , [BuyController::class, 'get_products_update'])->name('admin.get_products_update');
Route::post('/print-buy'                , [BuyController::class, 'print_buy'])->name('admin.print_buy');
Route::get('/download-buy/{id}'         , [BuyController::class, 'download'])->name('admin.download_buy');
Route::post('/options-print'            , [BuyController::class, 'options'])->name('admin.options_print');
Route::post('/delete-buy'               , [BuyController::class, 'delete'])->name('admin.delete_buy');
## Quote
Route::get('/quotes'                    , [QuoteController::class, 'index'])->name('admin.quotes')->middleware('auth'); 
Route::get('/get-quotes'                , [QuoteController::class, 'get'])->name('admin.get_quotes');
Route::get('/create-quote'              , [QuoteController::class, 'create'])->name('admin.create_quote')->middleware('auth');
Route::post('/load-cart-quotes'         , [QuoteController::class, 'load_cart'])->name('admin.load_cart_quotes');
Route::post('/searc-product-cart'       , [QuoteController::class, 'search_product_cart'])->name('admin.search_product_cart');
Route::post('/add-product-quote'        , [QuoteController::class, 'add_product'])->name('admin.add_product_quote');
Route::post('/store-product-quote'      , [QuoteController::class, 'store_product'])->name('admin.store_product_quote');
Route::post('/get-clients-quotes'       , [QuoteController::class, 'get_clients'])->name('admin.get_clients_update');
Route::post('/get-products-update-q'    , [QuoteController::class, 'get_products_update'])->name('admin.get_products_update_q');
Route::post('/get-serie-quote'          , [QuoteController::class, 'get_serie'])->name('admin.get_serie_quote');
Route::post('/store-product-quote-price', [QuoteController::class, 'store_product_quote_price'])->name('admin.store_product_quote_price');
Route::post('/delete-product-quote'     , [QuoteController::class, 'delete_product'])->name('admin.delete_product_quote');
Route::post('/get-price-product-quote'  , [QuoteController::class, 'get_price_product'])->name('admin.get_price_product_quote');
Route::post('/save-quote'               , [QuoteController::class, 'save'])->name('admin.save_quote');
Route::post('/print-quote'              , [QuoteController::class, 'print_quote'])->name('admin.print_quote');
Route::get('/quotes/download-quote/{id}', [QuoteController::class, 'download'])->name('admin.download_quote');
Route::post('/options-print-quote'      , [QuoteController::class, 'options'])->name('admin.options_print_quote');
Route::get('/test-quote'                , [QuoteController::class, 'test'])->name('admin.test_quote');
Route::get('/download-quote/{id}'       , [QuoteController::class, 'download'])->name('admin.download_quote');
Route::post('/gen-quote-voucher'        , [QuoteController::class, 'gen_voucher'])->name('admin.gen_quote_voucher');
Route::get('/edit-quote-{id}'           , [QuoteController::class, 'edit'])->name('admin.edit_quote');
Route::post('/get-product-quote-update'  , [QuoteController::class, 'get_product_update'])->name('admin.get_product_quote_update');
Route::post('/store-product-quote-update'  , [QuoteController::class, 'store_product_update'])->name('admin.store_product_quote_update');
Route::post('/gen-quote-update'         , [QuoteController::class, 'gen_update'])->name('admin.gen_quote_update');
## Arching Cash
Route::get('/cashes'                    , [ArchingCashController::class, 'index'])->name('admin.cashes')->middleware('auth');
Route::get('/get-arching-cashes'        , [ArchingCashController::class, 'get'])->name('admin.get_arching_cashes');
Route::post('/save-arching-cash'        , [ArchingCashController::class, 'save'])->name('admin.save_arching_cash');
Route::post('/close-cash'               , [ArchingCashController::class, 'close'])->name('admin.close_cash');
Route::post('/get-detail-cash'          , [ArchingCashController::class, 'get_detail_cash'])->name('admin.get_detail_cash');
Route::post('/get-detail-cashes'        , [ArchingCashController::class, 'get_detail_cashes'])->name('admin.get_detail_cashes');
Route::post('/get-summary'              , [ArchingCashController::class, 'get_summary'])->name('admin.get_summary');
Route::get('/download-detail-cash/{id}' , [ArchingCashController::class, 'download'])->name('admin.download_detail_cash');
## Sale Note
Route::get('/get-sale-notes'            , [SaleNoteController::class, 'get'])->name('admin.get_sale_notes');
Route::get('/sale-notes'                , [SaleNoteController::class, 'index'])->name('admin.sale_notes')->middleware('auth'); 
Route::get('/create-sale-note'          , [SaleNoteController::class, 'create'])->name('admin.create_sale_note')->middleware('auth');
Route::get('/test-sale'                 , [SaleNoteController::class, 'test'])->name('admin.test_sale');
Route::post('/load-serie-sale-note'     , [SaleNoteController::class, 'load_serie'])->name('admin.load_serie_sale_note');
Route::post('/load-cart-sale-notes'     , [SaleNoteController::class, 'load_cart'])->name('admin.load_cart_sale_notes');
Route::post('/add-product-sale-note'    , [SaleNoteController::class, 'add_product'])->name('admin.add_product_sale_note');
Route::post('/delete-product-sale-note' , [SaleNoteController::class, 'delete_product'])->name('admin.delete_product_sale_note');
Route::post('/store-product-sale-note'  , [SaleNoteController::class, 'store_product'])->name('admin.store_product_sale_note');
Route::post('/save-sale-note'           , [SaleNoteController::class, 'save'])->name('admin.save_sale_note');
Route::get('/test-ticket'               , [SaleNoteController::class, 'test_ticket'])->name('admin.test_ticket');
Route::post('/print-sale-note'          , [SaleNoteController::class, 'print'])->name('admin.print_sale_note');
Route::get('/download-sale-note/{id}'   , [SaleNoteController::class, 'download'])->name('admin.download_sale_note');
Route::post('/anulled-sale-note'        , [SaleNoteController::class, 'anulled'])->name('admin.anulled_sale_note');
## POS 
Route::get('/pos'                       , [PosController::class, 'index'])->name('admin.pos')->middleware('auth'); 
Route::post('/load-view-products'       , [PosController::class, 'view_products'])->name('admin.load_view_products');
Route::post('/search-view-product'      , [PosController::class, 'search_view_product'])->name('admin.search_view_product');
Route::post('/load-cart-pos'            , [PosController::class, 'load_cart'])->name('admin.load_cart_pos');
Route::post('/add-product-pos'          , [PosController::class, 'add_product'])->name('admin.add_product_pos');
Route::post('/delete-product-pos'       , [PosController::class, 'delete_product'])->name('admin.delete_product_pos');
Route::post('/store-product-pos'        , [PosController::class, 'store_product'])->name('admin.store_product_pos');
Route::post('/cancel-cart-pos'          , [PosController::class, 'cancel_cart'])->name('admin.cancel_cart_pos');
Route::post('/load-serie-pos'           , [PosController::class, 'load_serie'])->name('admin.load_serie_pos');
Route::post('/get-serie-pos'            , [PosController::class, 'get_serie'])->name('admin.get_serie_pos');
Route::post('/process-pay-pos'          , [PosController::class, 'process_pay'])->name('admin.process_pay_pos');
Route::post('/save-billing-pos'         , [PosController::class, 'save'])->name('admin.save_billing_pos');
Route::get('/test-billing'              , [PosController::class, 'test'])->name('admin.test_billing');
Route::post('/check-cash-active'        , [PosController::class, 'check_cash'])->name('admin.check_cash_active');
## Billing 
Route::get('/billings'                  , [BillingController::class, 'index'])->name('admin.billings')->middleware('auth'); 
Route::get('/get-billings'              , [BillingController::class, 'get'])->name('admin.get_billings');
Route::post('/update-cdr-bf'            , [BillingController::class, 'update_cdr_bf'])->name('admin.update_cdr_bf');
Route::post('/send-bf-sunat'            , [BillingController::class, 'send'])->name('admin.send_bf');
Route::post('/print-billing'            , [BillingController::class, 'print'])->name('admin.print_billing');
Route::get('/download-billing/{id}'     , [BillingController::class, 'download'])->name('admin.download_billing');
Route::get('/test-billing'              , [BillingController::class, 'test'])->name('admin.test_billing');
## Reports 
Route::get('/inventories-items'         , [InventoryReportController::class, 'products'])->name('admin.inventory_products')->middleware('auth');
Route::post('/search-inventory-products', [InventoryReportController::class, 'search_products'])->name('admin.search_inventory_products');
Route::post('/export-inventory-products', [InventoryReportController::class, 'export_products'])->name('admin.export_inventory_products');
// Customers
Route::get('/contacts-customers'        , [ContactReportController::class, 'customers'])->name('admin.contact_customers')->middleware('auth');
Route::post('/search-inventory-customers'   , [ContactReportController::class, 'search_customers'])->name('admin.search_contacts_customers');
Route::post('/export-inventory-customers'   , [ContactReportController::class, 'export_customers'])->name('admin.export_contacts_customers');
// Providers
Route::get('/contacts-providers'         , [ContactReportController::class, 'providers'])->name('admin.contact_providers')->middleware('auth');
Route::post('/search-inventory-providers'    , [ContactReportController::class, 'search_providers'])->name('admin.search_contacts_providers');
Route::post('/export-inventory-providers'    , [ContactReportController::class, 'export_providers'])->name('admin.export_contacts_providers');
// Sales General
Route::get('/sales-general'          , [SaleReportController::class, 'sales_general'])->name('admin.sales_general')->middleware('auth');
Route::post('/search-sales-general'  , [SaleReportController::class, 'search_sales_general'])->name('admin.search_sales_general');
Route::post('/export-sales-general'  , [SaleReportController::class, 'export_sales_general'])->name('admin.export_sales_general');
// Sales Seller
Route::get('/sales-seller'          , [SaleReportController::class, 'sales_seller'])->name('admin.sales_seller')->middleware('auth');
Route::post('/search-sales-seller'  , [SaleReportController::class, 'search_sales_seller'])->name('admin.search_sales_seller');
Route::post('/export-sales-seller'  , [SaleReportController::class, 'export_sales_seller'])->name('admin.export_sales_seller');
// Sales Products
Route::get('/sales-product'          , [SaleReportController::class, 'sales_product'])->name('admin.sales_product')->middleware('auth');
Route::post('/search-sales-product'  , [SaleReportController::class, 'search_sales_product'])->name('admin.search_sales_product');
Route::post('/export-sales-product'  , [SaleReportController::class, 'export_sales_product'])->name('admin.export_sales_product');
// Buys General
Route::get('/purchases-general', [PurchaseReportController::class, 'purchases_general'])->name('admin.purchases_general')->middleware('auth');
Route::post('/search-purchase-general', [PurchaseReportController::class, 'search_purchases_general'])->name('admin.search_purchases_general');
Route::post('/export-purchase-general', [PurchaseReportController::class, 'export_purchases_general'])->name('admin.export_purchases_general');
// Buys Provider
Route::get('/purchases-provider'           , [PurchaseReportController::class, 'purchases_provider'])->name('admin.purchases_provider')->middleware('auth');
Route::post('/search-purchase-provider'    , [PurchaseReportController::class, 'search_purchases_provider'])->name('admin.search_purchases_provider');
Route::post('/export-purchase-provider'    , [PurchaseReportController::class, 'export_purchases_provider'])->name('admin.export_purchases_provider');
// Bill
Route::get('/purchases-expenses'            , [BillReportController::class, 'purchases'])->name('admin.purchases_expenses')->middleware('auth');
Route::post('/search-purchase-expenses'     , [BillReportController::class, 'search_expenses'])->name('admin.search_purchases_expenses');
Route::post('/export-purchase-expenses'     , [BillReportController::class, 'export_expenses'])->name('admin.export_purchases_expenses');
## Credit Note
Route::get('/credit-notes'                   , [CreditNoteController::class, 'index'])->name('admin.credit_notes')->middleware('auth'); 
Route::get('/create-nc-{id}'                  , [CreditNoteController::class, 'create'])->name('admin.create_nc')->middleware('auth');
Route::get('/get-credit-notes'               , [CreditNoteController::class, 'get'])->name('admin.get_credit_notes');
Route::post('/save-nc'                       , [CreditNoteController::class, 'save'])->name('admin.save_nc');
Route::post('/send-nc'                       , [CreditNoteController::class, 'send'])->name('admin.send_nc');
Route::post('/update-cdr-nc'                 , [CreditNoteController::class, 'update_cdr'])->name('admin.update_cdr_nc');
## User
Route::get('/users'                         , [UserController::class, 'index'])->name('admin.users')->middleware('can:admin.users');
Route::get('/get-users'                     , [UserController::class, 'get'])->name('admin.get_users');
Route::post('/save-user'                    , [UserController::class, 'save'])->name('admin.save_user');
Route::post('/detail-user'                  , [UserController::class, 'detail'])->name('admin.detail_user');
Route::post('/store-user'                   , [UserController::class, 'store'])->name('admin.store_user');
Route::post('/delete-user'                  , [UserController::class, 'delete'])->name('admin.delete_user');
Route::post('/view-role'                    , [UserController::class, 'view_role'])->name('admin.view_role')->middleware('auth');
Route::post('/update-role'                  , [UserController::class, 'update'])->name('admin.update_role');

##
Route::get('/reference-guides'              , [ReferenceGuideController::class, 'index'])->name('admin.reference_guides')->middleware('auth');
Route::get('/get-reference-guides'          , [ReferenceGuideController::class, 'get'])->name('admin.get_reference_guides');

Route::get('/create-guide'                  , [ReferenceGuideController::class, 'create'])->name('admin.create_reference_guide')->middleware('auth');
Route::post('/load-serie-guides'            , [ReferenceGuideController::class, 'load_serie'])->name('admin.load_serie_guides');
Route::post('/get-up-senders'               , [ReferenceGuideController::class, 'get_up_senders'])->name('admin.get_up_senders');
Route::post('/get-up-clients'               , [ReferenceGuideController::class, 'get_up_clients'])->name('admin.get_up_clients');
Route::post('/get-up-drivers'               , [ReferenceGuideController::class, 'get_up_drivers'])->name('admin.get_up_drivers');
Route::post('/load-cart-reference-guides'     , [ReferenceGuideController::class, 'load_cart'])->name('admin.load_cart_reference_guides');
Route::post('/add-product-reference-guide'    , [ReferenceGuideController::class, 'add_product'])->name('admin.add_product_reference_guide');
Route::post('/delete-product-reference-guide' , [ReferenceGuideController::class, 'delete_product'])->name('admin.delete_product_reference_guide');
Route::post('/store-product-reference-guide'  , [ReferenceGuideController::class, 'store_product'])->name('admin.store_product_reference_guide');
Route::get('/'         , [ReferenceGuideController::class, 'tracking'])->name('admin.tracking')->middleware('guest');
Route::post('/save-reference-guide'  , [ReferenceGuideController::class, 'save'])->name('admin.save_reference_guide');
Route::post('/print-reference-guide'         , [ReferenceGuideController::class, 'print'])->name('admin.print_reference_guide');
Route::post('/view-detail-guide'         , [ReferenceGuideController::class, 'view_detail'])->name('admin.view_detail_guide');
Route::post('/detail-guide'         , [ReferenceGuideController::class, 'detail'])->name('admin.detail_guide');
Route::post('/store-reference-guide'         , [ReferenceGuideController::class, 'store'])->name('admin.store_reference_guide');
Route::post('/gen-voucher-guide'         , [ReferenceGuideController::class, 'gen_voucher'])->name('admin.gen_voucher_guide');
Route::post('/gen-voucher-sale-note'      , [ReferenceGuideController::class, 'gen_voucher_sale_note'])->name('admin.gen_voucher_sale_note');
Route::post('/search'      , [ReferenceGuideController::class, 'search'])->name('admin.search_guide');
Route::post('/view-detail-confirm'     , [ReferenceGuideController::class, 'view_detail_confirm'])->name('admin.view_detail_confirm');
Route::post('/view-detail-confirm-sale-note'     , [ReferenceGuideController::class, 'view_detail_confirm_sale_note'])->name('admin.view_detail_confirm_sale_note');
