<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Reporte de Compras por Proveedor</title>
    <style>
        #cabecera {
            text-align: center;
            text-decoration: underline;
        }

        body {
            font-family: sans-serif;
        }

        .th_informacion {
            text-align: left;
            width: 230px;
        }

        .td_informacion {
            text-align: left;
        }

        .th_items,
        .td_items {
            text-align: center;
        }

        #table_items {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        #thead_items {
            width: 100%;
        }

        .border-solid {
            border: 1px solid #dee2e6
        }

        .text-right {
            text-align: right;
        }

        .text-danger {
            color: rgb(234, 84, 85);
        }

        .pay_mode {
            margin-bottom: 0px;
            margin-top: 0px;
            text-align: center;
        }
    </style>
</head>

<body>
    <div id="cabecera">
        <h4>REPORTE DE COMPRAS POR PROVEEDOR</h4>
    </div>

    <div id="informacion">
        <table style="font-size: 15px;">
            <tr>
                <th class="th_informacion">RUC</th>
                <td class="td_informacion">: <?php echo e($business->ruc); ?></td>
            </tr>

            <tr>
                <th class="th_informacion">EMPRESA</th>
                <td class="td_informacion">: <?php echo e($business->nombre_comercial); ?></td>
            </tr>

            <tr>
                <th class="th_informacion">CANTIDAD DE COMPRAS</th>
                <td class="td_informacion">: <?php echo e($quantity); ?></td>
            </tr>
        </table>
    </div>

    <div id="items">
        <table id="table_items">
            <thead id="thead_items" style="font-size: 12px;">
                <tr>
                    <th colspan="2" class="th_items border-solid">Documento</th>
                    <th colspan="2" class="th_items border-solid">Cliente</th>
                    <th colspan="5" class="th_items border-solid">Soles</th>
                </tr>

                <tr>
                    <th class="th_items border-solid">Fecha</th>
                    <th class="th_items border-solid">Documento</th>
                    <th class="th_items border-solid">RUC / DNI</th>
                    <th class="th_items border-solid">Razón Social</th>
                    <th class="th_items border-solid">Exonerada</th>
                    <th class="th_items border-solid">Gravada</th>
                    <th class="th_items border-solid">Inafecta</th>
                    <th class="th_items border-solid">IGV</th>
                    <th class="th_items border-solid">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $buys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $total  += $item["total"];
                ?>
                    <tr style="font-size: 12px;">
                        <td class="td_items border-solid"><?php echo e(date('d-m-Y', strtotime($item["fecha_emision"]))); ?></td>
                        <td class="td_items border-solid"><?php echo e($item["serie"] . "-" . $item["correlativo"]); ?></td>
                        <td class="td_items border-solid"><?php echo e($item["dni_ruc"]); ?></td>
                        <td class="text-left border-solid"><?php echo e($item["proveedor"]); ?></td>
                        <td class="td_items border-solid"><?php echo e($item["exonerada"]); ?></td>
                        <td class="td_items border-solid"><?php echo e($item["gravada"]); ?></td>
                        <td class="td_items border-solid"><?php echo e($item["inafecta"]); ?></td>
                        <td class="td_items border-solid"><?php echo e($item["igv"]); ?></td>
                        <td class="td_items border-solid"><?php echo e($item["total"]); ?></td>
                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8"></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td colspan="8" class="text-right border-solid">Total S/ &nbsp;</td>
                        <td class="td_items border-solid"><?php echo e(number_format($total, 2, ".", "")); ?></td>
                    </tr>
            </tbody>
        </table>
    </div>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\mytems2.0\sales\resources\views/admin/reports/purchases/providers/pdf.blade.php ENDPATH**/ ?>