<script>
    $('body').on('click', '.btn-open-whatsapp', function()
    {
        let id = $(this).data('id');
        $('#modalSendEmail .btn-email').attr('idnotaventa', id);
        $('#modalSendEmail').modal('show');
    });

    $('body').on('click', '#modalSendEmail .btn-email', function()
    {
        event.preventDefault();
        let id              = $(this).attr('idnotaventa');  
            input__email    = $('#modalSendEmail input[name="input__email"]').val(),
            html            = '';

        $.ajax({
            url     : "<?php echo e(route('admin.send_sale_note')); ?>",
            method  : "POST",
            data    : {
                '_token'        : "<?php echo e(csrf_token()); ?>",
                id              : id,
                input__email    : input__email
            },
            beforeSend   : function(){
                $('#modalSendEmail .text-send').addClass('d-none');
                $('#modalSendEmail .text-sending').removeClass('d-none');
            },
            success : function(r)
            {
                if(!r.status)
                {
                    $('#modalSendEmail .text-send').removeClass('d-none');
                    $('#modalSendEmail .text-sending').addClass('d-none');
                    toast_msg(r.msg, r.type);
                    return;
                }

                $('#modalSendEmail .text-send').removeClass('d-none');
                $('#modalSendEmail .text-sending').addClass('d-none');
                toast_msg(r.msg, r.type);
            },
            dataType: "json"
        });
    });
    
    $('body').on('click', '.btn-print', function()
    {
        let id = $(this).data('id');
        $.ajax({
            url: "<?php echo e(route('admin.print_sale_note')); ?>",
            method: "POST",
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                id: id
            },
            beforeSend: function() {
                block_content('#layout-content');
            },
            success: function(r) {
                if (!r.status) {
                    close_block('#layout-content');
                    toast_msg(r.msg, r.type);
                    return;
                }
                close_block('#layout-content');
                let pdf                 =   `<?php echo e(asset('files/sale-notes/ticket/${r.pdf}')); ?>`;
                var iframe              = document.createElement('iframe');
                iframe.style.display    = "none";
                iframe.src              = pdf;
                document.body.appendChild(iframe);
                iframe.contentWindow.focus();
                iframe.contentWindow.print();
            },
            dataType: "json"
        });
    });

    $('body').on('click', '.btn-download', function()
    {
        event.preventDefault();
        let id              = $(this).data('id');
        base_url            = "<?php echo e(url('/')); ?>",
        url_print           = `${base_url}/download-sale-note/${id}`;
        window.open(url_print);
    });

    $('body').on('click', '.btn-confirm', function()
    {
        event.preventDefault();
        let id      = $(this).data('id');
        Swal.fire({
            title: 'Anular',
            text: "¿Desea anular la venta?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Si, anular',
            cancelButtonText: 'Cancelar',
            customClass: {
                confirmButton: 'btn btn-primary',
                cancelButton: 'btn btn-outline-danger ml-1'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.value) 
            {
                $.ajax({
                    url         : "<?php echo e(route('admin.anulled_sale_note')); ?>",
                    method      : 'POST',
                    data        : {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        id      : id
                    },
                    success     : function(r){
                        if(!r.status)
                        {
                            toast_msg(r.msg, r.type);
                            return;
                        }

                        toast_msg(r.msg, r.type);
                        reload_table();
                    },
                    dataType    : 'json'
                });
            }
        });
    });
</script><?php /**PATH C:\xampp\htdocs\mytems2.0\sales\resources\views/admin/sale_notes/js-store.blade.php ENDPATH**/ ?>