<script>
    function load_serie() {
        $.ajax({
            url: "<?php echo e(route('admin.load_serie_guides')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>"
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.title, r.type);
                    return;
                }

                $('#form_save_reference input[name="serie"]').val(r.serie.serie);
                $('#form_save_reference input[name="correlativo"]').val(r.serie.correlativo);
            },
            dataType: 'json'
        });
    }

    // Remitentes
    function success_save_sender(msg = null, type = null, idtipocomprobante = null, last_id = null) {
        toast_msg(msg, type);
        load_senders(idtipocomprobante);
        setTimeout(() => {
            $('#form_save_reference select[name="idremitente"]').val(last_id);
            $('#form_save_reference select[name="idremitente"]').trigger('change');
        }, 500);
    }

    function open_modal_sender(){
    }
    function load_senders(idtipo_documento) {
        $.ajax({
            url: "<?php echo e(route('admin.get_up_senders')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                idtipo_documento: idtipo_documento
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.type);
                    return;
                }

                let html_senders = '';
                $.each(r.senders, function(index, sender) {
                    html_senders +=
                        `<option value="${sender.id}">${sender.dni_ruc + ' - ' + sender.nombres}</option>`;
                });

                $('#form_save_reference select[name="idremitente"]').html(html_senders).select2();
            },
            dataType: 'json'
        });
    }

    // Destinatario
    function success_save_client(msg = null, type = null, idtipocomprobante = null, last_id = null) {
        toast_msg(msg, type);
        load_clients(idtipocomprobante);
        setTimeout(() => {
            $('#form_save_reference select[name="iddestinatario"]').val(last_id);
            $('#form_save_reference select[name="iddestinatario"]').trigger('change');
        }, 500);
    }

    function open_modal_client(){}
    function load_clients(idtipo_documento) {
        $.ajax({
            url: "<?php echo e(route('admin.get_up_clients')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                idtipo_documento: idtipo_documento
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.type);
                    return;
                }

                let html_clients = '';
                $.each(r.clients, function(index, client) {
                    html_clients +=
                        `<option value="${client.id}">${client.dni_ruc + ' - ' + client.nombres}</option>`;
                });

                $('#form_save_reference select[name="iddestinatario"]').html(html_clients).select2();
            },
            dataType: 'json'
        });
    }

    // Conductor
    function success_save_driver(msg = null, type = null, idtipocomprobante = null, last_id = null) {
        toast_msg(msg, type);
        load_drivers(idtipocomprobante);
        setTimeout(() => {
            $('#form_save_reference select[name="idconductor"]').val(last_id);
            $('#form_save_reference select[name="idconductor"]').trigger('change');
        }, 500);
    }

    function open_modal_driver(){
    }

    function load_drivers(idtipo_documento) {
        $.ajax({
            url: "<?php echo e(route('admin.get_up_drivers')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                idtipo_documento: idtipo_documento
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.type);
                    return;
                }

                let html_drivers = '';
                $.each(r.drivers, function(index, driver) {
                    html_drivers +=
                        `<option value="${driver.id}">${driver.nombres}</option>`;
                });

                $('#form_save_reference select[name="idconductor"]').html(html_drivers).select2();
            },
            dataType: 'json'
        });
    }

    function success_save_product(msg = null, type = null)
    {
        $('#modalAddProduct').modal('hide');
        toast_msg(msg, type);
        load_products();
    }

    function load_products() {
        $.ajax({
            url: "<?php echo e(route('admin.get_products_update_q')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>"
            },
            success: function(data) {
                let html_products = '<option value=""></option>';
                $.each(data, function(index, product) {
                    html_products +=
                        `<option value="${product.id}">${product.descripcion + ' - S/' + product.precio_venta}</option>`;
                });

                $('#form_save_to_product select[name="product"]').html(html_products);
                $('#form_save_to_product select[name="product"]').select2({
                    dropdownParent: $('#modalAddToProduct .modal-body'),
                    placeholder: "[SELECCIONE]"
                });
            },
            dataType: 'json'
        });
    }

    $('body').on('click', '.btn-add-product', function() {
        event.preventDefault();
        $('#modalAddToProduct').modal('show');
        $('#form_save_to_product select[name="product"]').select2({
            dropdownParent: $('#modalAddToProduct .modal-body'),
            placeholder: "[SELECCIONE]",
        });
    });

    $('#modalAddToProduct select[name="product"]').on('change', function() {
        let value = $(this).val(),
            cantidad = $('#form_save_to_product input[name="cantidad"]').val();
        if (value.trim() == "") {
            return;
        }
        $.ajax({
            url: "<?php echo e(route('admin.get_price_product_quote')); ?>",
            method: "POST",
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                id: value
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.type);
                    return;
                }
                $('#form_save_to_product input[name="precio"]').val(r.product.precio_venta);
            },
            dataType: "json"
        });
    });

    touch_down('#form_save_to_product input[name="cantidad"]', 'product');
    touch_up('#form_save_to_product input[name="cantidad"]', 'product');

    function load_cart() {
        $.ajax({
            url: "<?php echo e(route('admin.load_cart_reference_guides')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>"
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.title, r.type);
                    return;
                }

                $('#tbody_reference_guides').html(r.html_cart);
                $('#wrapper_totals').html(r.html_totales);
            },
            dataType: 'json'
        });
    }

    $('body').on('click', '#form_save_to_product .btn-save', function() {
        event.preventDefault();
        let select_product = $('#form_save_to_product select[name="product"]').val(),
            cantidad = parseFloat($('#form_save_to_product input[name="cantidad"]').val()),
            precio = parseFloat($('#form_save_to_product input[name="precio"]').val());
        if (select_product.trim() == "") {
            toast_msg('Debe seleccionar un producto', 'warning');
            return;
        }
        if (cantidad <= 0) {
            toast_msg('Ingrese una cantidad válida', 'warning');
            return;
        }
        if (precio <= 0) {
            toast_msg('Ingrese un precio válido', 'warning');
            return;
        }

        $.ajax({
            url: "<?php echo e(route('admin.add_product_reference_guide')); ?>",
            method: "POST",
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                id: select_product,
                cantidad: cantidad,
                precio: precio
            },
            beforeSend: function() {
                $('#form_save_to_product .btn-save').prop('disabled', true);
                $('#form_save_to_product .text-save').addClass('d-none');
                $('#form_save_to_product .text-saving').removeClass('d-none');
            },
            success: function(r) {
                if (!r.status) {
                    $('#form_save_to_product .btn-save').prop('disabled', false);
                    $('#form_save_to_product .text-save').removeClass('d-none');
                    $('#form_save_to_product .text-saving').addClass('d-none');
                    toast_msg(r.msg, r.type);
                    return;
                }

                toast_msg(r.msg, r.type);
                $('#form_save_to_product .btn-save').prop('disabled', false);
                $('#form_save_to_product .text-save').removeClass('d-none');
                $('#form_save_to_product .text-saving').addClass('d-none');
                $('#form_save_to_product input[name="cantidad"]').val('1');
                $('#form_save_to_product input[name="precio"]').val('');
                $('#form_save_to_product select[name="product"]').val('').trigger('change');
                $('#form_save_to_product select[name="product"]').select2({
                    dropdownParent: $('#modalAddToProduct .modal-body'),
                    placeholder: "[SELECCIONE]",
                });
                load_cart();
            },
            dataType: "json"
        });
    });

    $('body').on('click', '.btn-delete-product', function() {
        event.preventDefault();
        let id = $(this).data('id');
        $.ajax({
            url: "<?php echo e(route('admin.delete_product_reference_guide')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                id: id
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.title, r.type);
                    return;
                }
                load_cart();
            },
            dataType: 'json'
        });
        return;
    });

    $('body').on('click', '.btn-down', function() {
        event.preventDefault();
        let id = $(this).data('id'),
            cantidad = parseInt($(this).data('cantidad')),
            cantidad_enviar = cantidad - 1,
            precio = parseFloat($(this).data('precio'));

        if (cantidad_enviar <= 0) {
            toast_msg('La cantidad no puede ser menor a 1', 'warning');
            return;
        }

        $.ajax({
            url: "<?php echo e(route('admin.store_product_reference_guide')); ?>",
            method: "POST",
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                id: id,
                cantidad: cantidad_enviar,
                precio: precio
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.type);
                    return;
                }

                toast_msg(r.msg, r.type);
                load_cart();
            },
            dataType: "json"
        });
    });

    $('body').on('click', '.btn-up', function() {
        event.preventDefault();
        let id = $(this).data('id'),
            cantidad = parseInt($(this).data('cantidad')),
            cantidad_enviar = cantidad + 1,
            precio = parseFloat($(this).data('precio'));

        $.ajax({
            url: "<?php echo e(route('admin.store_product_reference_guide')); ?>",
            method: "POST",
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                id: id,
                cantidad: cantidad_enviar,
                precio: precio
            },
            success: function(r) {
                if (!r.status) {
                    toast_msg(r.msg, r.type);
                    return;
                }

                toast_msg(r.msg, r.type);
                load_cart();
            },
            dataType: "json"
        });
    });

    $('body').on('change', '.input-update', function() {
        let precio = $(this).val(),
            cantidad = $(this).data('cantidad'),
            id = $(this).data('id');

        if (precio.trim() == '') {
            return;
        }
        if (isNaN(precio)) {
            toast_msg('Solo se permiten números', 'warning');
            $(this).focus();
            return;
        }

        $.ajax({
            url: "<?php echo e(route('admin.store_product_reference_guide')); ?>",
            method: 'POST',
            data: {
                '_token': "<?php echo e(csrf_token()); ?>",
                id: id,
                cantidad: cantidad,
                precio: precio
            },
            success: function(r) {
                if (!r.status) {
                    load_cart();
                    toast_msg(r.msg, r.type);
                    return;
                }

                toast_msg(r.msg, r.type);
                load_cart();
            },
            dataType: 'json'
        });
    });

    $('#form_save_reference .btn-save').on('click', function() {
        event.preventDefault();
        Swal.fire({
            title: "Ingrese una contraseña",
            input: "password",
            inputPlaceholder: 'La contraseña debe tener 04 digitos',
            inputAttributes: {
                autocapitalize: "off",
                maxlength: 4
            },
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: "Confirmar",
            cancelButtonText: "Cancelar",
            showLoaderOnConfirm: true,
            preConfirm: async (login) => {},
            allowOutsideClick: false
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#form_save_reference input[name="contrasena"]').val(result.value);
                    let value = result.value,
                        form  = $('#form_save_reference').serialize();
                    $.ajax({
                        url             : "<?php echo e(route('admin.save_reference_guide')); ?>",
                        method          : 'POST',
                        data            : form,
                        beforeSend      : function() {
                            $('#form_save_reference .btn-save').prop('disabled', true);
                            $('#form_save_reference .text-save').addClass('d-none');
                            $('#form_save_reference .text-saving').removeClass('d-none');
                        },
                        success         : function(r){
                            if(!r.status){
                                $('#form_save_reference .btn-save').prop('disabled', false);
                                $('#form_save_reference .text-save').removeClass('d-none');
                                $('#form_save_reference .text-saving').addClass('d-none');
                                toast_msg(r.msg, r.type);
                                open_swal();
                                return;
                            }

                            $('#form_save_reference .btn-save').prop('disabled', false);
                            $('#form_save_reference .text-save').removeClass('d-none');
                            $('#form_save_reference .text-saving').addClass('d-none');
                            load_cart();
                            load_serie();
                            load_clients(1);
                            load_drivers(1);
                            load_senders(1);
                            $('#form_save_reference select[name="modo_pago"]').val(1).trigger('change');
                            let pdf                 = `<?php echo e(asset('files/reference-guides/${r.pdf}')); ?>`;
                            var iframe              = document.createElement('iframe');
                            iframe.style.display    = "none";
                            iframe.src              = pdf;
                            document.body.appendChild(iframe);
                            iframe.contentWindow.focus();
                            iframe.contentWindow.print();
                        },
                        dataType        : "json"
                    });
                }
        });
    });

    async function open_swal() {
        await Swal.fire({
            title: "Ingrese una contraseña",
            input: "password",
            inputPlaceholder: 'La contraseña debe tener 04 digitos',
            inputAttributes: {
                autocapitalize: "off",
                maxlength: 4
            },
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: "Confirmar",
            cancelButtonText: "Cancelar",
            showLoaderOnConfirm: true,
            preConfirm: async (login) => {},
            allowOutsideClick: false
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#form_save_reference input[name="contrasena"]').val(result.value);
                    let value = result.value,
                        form  = $('#form_save_reference').serialize();
                    $.ajax({
                        url             : "<?php echo e(route('admin.save_reference_guide')); ?>",
                        method          : 'POST',
                        data            : form,
                        beforeSend      : function() {
                            $('#form_save_reference .btn-save').prop('disabled', true);
                            $('#form_save_reference .text-save').addClass('d-none');
                            $('#form_save_reference .text-saving').removeClass('d-none');
                        },
                        success         : function(r){
                            if(!r.status){
                                $('#form_save_reference .btn-save').prop('disabled', false);
                                $('#form_save_reference .text-save').removeClass('d-none');
                                $('#form_save_reference .text-saving').addClass('d-none');
                                toast_msg(r.msg, r.type);
                                open_swal();
                                return;
                            }
                            $('#form_save_reference .btn-save').prop('disabled', false);
                            $('#form_save_reference .text-save').removeClass('d-none');
                            $('#form_save_reference .text-saving').addClass('d-none');
                            load_cart();
                            load_serie();
                            load_clients(1);
                            load_drivers(1);
                            load_senders(1);
                            $('#form_save_reference select[name="modo_pago"]').val(1).trigger('change');
                            let pdf                 = `<?php echo e(asset('files/reference-guides/${r.pdf}')); ?>`;
                            var iframe              = document.createElement('iframe');
                            iframe.style.display    = "none";
                            iframe.src              = pdf;
                            document.body.appendChild(iframe);
                            iframe.contentWindow.focus();
                            iframe.contentWindow.print();
                        },
                        dataType        : "json"
                    });
                }
            });
    }

    $(document).ready(function() {
        $('#form_save_reference select[name="idorigen"]').val("<?php echo e(Auth::user()['idorigen']); ?>").select2();
        $('#form_save_reference select[name="iddestino"]').select2();
        $('#form_save_reference select[name="idremitente"]').select2();
        $('#form_save_reference select[name="iddestinatario"]').select2();
        $('#form_save_reference select[name="idconductor"]').select2();
        load_cart();
        load_serie();
    });
</script><?php /**PATH C:\xampp\htdocs\courier\resources\views/admin/reference_guides/create/js-create.blade.php ENDPATH**/ ?>